﻿package {
  import flash.display.*;
  import flash.events.*;
  import flash.utils.*;
  import flash.text.*;
  import flash.net.*;
  import flash.system.*;
  
  public class DisplayWindow extends Sprite {
    
    // Constants:
    // Public Properties:
    //public var statusLabel : Label;
  
    // Private Properties:
    private var thinkGearSocket : Socket;
    private var timer : Timer;
    
    // set up some variables to store the headset data
    private var poorSignal : uint = 0;
    private var attention : uint = 0;
    private var meditation : uint = 0;
    private var dta : Number = 0.0;
    private var tta : Number = 0.0;
    private var bta1 : Number = 0.0;
    private var bta2 : Number = 0.0;
    private var alp1 : Number = 0.0;
    private var alp2 : Number = 0.0;
    private var gam1 : Number = 0.0;
    private var gam2 : Number = 0.0;
  
    private var debugContent : Array;
  
    // Initialization:
    public function DisplayWindow() { 
      debugContent = new Array();
  
      thinkGearSocket = new Socket();
      
      debugContent.push("Applet started at " + getTimer() + " msec");
    
      // add socket event listeners
      thinkGearSocket.addEventListener(Event.CONNECT, connectHandler);
      thinkGearSocket.addEventListener(ProgressEvent.SOCKET_DATA, dataHandler);
      thinkGearSocket.addEventListener(Event.CLOSE, closeHandler);
	  
	  // error handling
      thinkGearSocket.addEventListener(IOErrorEvent.IO_ERROR,
                       function(e : Event){
						 connectButton.label = "Connect";
                         debugContent.push("Connection attempt failed. Is the server running? (" + e.type + ")");
                       });
    
	  thinkGearSocket.addEventListener(SecurityErrorEvent.SECURITY_ERROR,
									   function(e : Event){
										   connectButton.label = "Connect";
										   debugContent.push("Connection attempt failed. Is the server running? (" + e.type + ")");
									   });
	
      // set up a timer, then have it update the attention and meditation dials
      timer = new Timer(1000);
    
	  // update the meter values every timer tick
      timer.addEventListener(TimerEvent.TIMER,
                             function(e : Event){
                               attentionDial.updateDialValue(attention);
                               meditationDial.updateDialValue(meditation);
                               qualityMeter.updateSignalQuality(poorSignal);
                             });
    
      timer.start();
    
	  // update the contents of the debug display every frame
      addEventListener(Event.ENTER_FRAME,
                       function(e : Event){
                         while(debugContent.length > 4)
                           debugContent.shift();
               
                         debugDisplay.text = debugContent.join("\n");
                       });
    
	  // handle clicks on the "Connect / Disconnect" button
      connectButton.addEventListener(MouseEvent.CLICK,
                                     function(e : Event){
                                       if(thinkGearSocket.connected){
                                         disconnectSocket();
                                         connectButton.label = "Connect";
                                       }
                                       else {
                                         connectSocket();
                                         connectButton.label = "Disconnect";
                                       }
                                     });
    }
  
    // Public Methods:
    // Protected Methods:
    
    private function connectHandler(e : Event){
      qualityMeter.setConnected();
      debugContent.push("Connected at " + getTimer() + " msec");
    }
    
    private function dataHandler(e : ProgressEvent){
      // buffer to store the headset data
      var buffer : ByteArray = new ByteArray();
    
      // read the bytes from the socket
      thinkGearSocket.readBytes(buffer, 0, thinkGearSocket.bytesAvailable);
      
      buffer.position = 1;          // set buffer position to anticipate SYNC bytes
      buffer.endian = Endian.BIG_ENDIAN;    // set float interpretation to little-endian
      
      // let's look for the SYNC bytes.
      // the loop consumes the buffer until two consecutive 0xAA bytes are seen
      while(buffer.position < buffer.length && 
            buffer.readUnsignedByte() != 0xAA && buffer[buffer.position - 1] != 0xAA)
        continue;
      
      // now process the buffer.
      while(buffer.position < buffer.length){
        // read the CODE byte
        var code : uint = buffer.readUnsignedByte();
        
        switch(code){
          // signal quality - read a single byte
          case 0x02:
            poorSignal = buffer.readUnsignedByte();
            break;
          // attention - read a single byte
          case 0x04:
            attention = buffer.readUnsignedByte();
            break;
          // meditation - read a single byte
          case 0x05:
            meditation = buffer.readUnsignedByte();
            break;
          // EEG powers - read eight floats (8 * 4 bytes)
          case 0x81:
            var eegPowerLength : Number = buffer.readUnsignedByte();
            dta = buffer.readFloat();
            tta = buffer.readFloat();
            bta1 = buffer.readFloat();
            bta2 = buffer.readFloat();
            alp1 = buffer.readFloat();
            alp2 = buffer.readFloat();
            gam1 = buffer.readFloat();
            gam2 = buffer.readFloat();
            break;
      default:
        debugContent.push("Unexpected code " + code + " seen at " + getTimer() + " msec");
      break;
        }
      }
      
      /*
      trace("Attention: " + attention + "\n" + 
          "Meditation: " + meditation + "\n" +
          "Delta: " + dta.toExponential(4) + "\n" +
          "Theta: " + tta.toExponential(4) + "\n" +
          "Beta: " + bta1.toExponential(4) + ", " + bta2.toExponential(4) + "\n" +
          "Alpha: " + alp1.toExponential(4) + ", " + alp2.toExponential(4) + "\n" +
          "Gamma: " + gam1.toExponential(4) + ", " + gam2.toExponential(4));
      */
      
      thinkGearSocket.flush();
    }
    
    private function closeHandler(e : Event){
      attentionDial.enable = false;
      meditationDial.enable = false;
      qualityMeter.setDisconnected();
      debugContent.push("Disconnected at " + getTimer() + " msec");
    }
  
    private function connectSocket(){
      attentionDial.enable = true;
      meditationDial.enable = true;
      debugContent.push("Attempting connection to 127.0.0.1:13854 at " + getTimer() + " msec");
      thinkGearSocket.connect("127.0.0.1", 13854);
    }
  
    private function disconnectSocket(){
      thinkGearSocket.close();
      closeHandler(null);
    }
  }
}